<?php
/**
 * Pod
 */
class Pod{
    public $scheduleid='';
    public $reference='';
    public $ssiid='';
    public $flawsize='';
    public $condemnationcriteria='';
    public $previousflawsize='';
    public $inspectiondate='';
    public $previousinspectiondate='';
    public $odometer='';
    public $previousodometer='';
    public $scheduletype='';
    public $rcm='';

    public $fa;
    public $fc1;
    public $fc;
    public $fb1;
    public $fb2;
    public $fb;
    public $fj;
    public $fk;
    public $fl;
    public $fm;
    public $fe;
    public $ff;
    public $fg;
    public $fh;
    public $fi;
    public $fn;
    public $fd1;
    public $fd;
    public $fo;
    public $fp;
    public $fq;
    public $fz;

    public function calculate($scheduletime){
  
    
        $rm=strtotime($this->previousinspectiondate);
        $rn=strtotime($this->inspectiondate);
        $rf=strtotime($this->rcm->RCM32);
        $aDay=24*60*60;
        $offset=$scheduletime[$this->scheduleid];

        //fa - simply get value from references rn - the latest inspection date
        $this->fa=$rn;

        //fc1 - if previous inspection date(rm) and latest inspection date(rn) are both present,
        // minus rm from rn and convert to years  
        $this->fc1=($rm&&$rn)?((($rn-$rm)/$aDay/365)):false;

        //fc - if SSI is time based(rb), return empty string, else if previous inspection date(rm) 
        //and latest inspection date(rn) are both present, divide inspection interval (rc) by
        if(strtolower($this->rcm->RCM19)=="time"){
             $this->fc=0;
        }
        else{
             if($this->fc1){
                 $this->fc=($offset/($this->odometer-$this->previousodometer))*($this->fc1*365); 
             }
             else{
                 $this->fc=($offset/$this->rcm->RCM30)*365;
             }
        }

        //fb1
        //$date = strtotime(date("Y-m-d", strtotime($date)) . " +2 week");
        //$offset = $this->rcm->RCM21;
        $offset=$scheduletime[$this->scheduleid]; 
        //$this->fb1=strtolower($this->rcm->RCM19)=="time"?date('m/d/Y', strtotime("+$offset months", strtotime($rn))):'';
        $this->fb1=(strtolower($this->rcm->RCM19)=="time"&&$rn!="")?strtotime(date("Y-m-d",$rn) . " +$offset months"):''; 
        
        //fb2
        $offset = $this->rcm->RCM21; 
        //$this->fb2=strtolower($this->rcm->RCM19)=="time"?date('m/d/Y', strtotime("+$offset months", strtotime($rf))):'';
        $this->fb2=(strtolower($this->rcm->RCM19)=="time"&&$rn=="")?strtotime(date("m/d/Y",$rf) . " +$offset months"):'';
        
        //fb3 
        $this->fb3=(strtolower($this->rcm->RCM19)=="use"&&$rn!="")?strtotime(date('m/d/Y',$rn+($this->fc*$aDay))):'';

        //fb4
        $this->fb4=(strtolower($this->rcm->RCM19)=="use"&&$rn=="")?strtotime(date('m/d/Y',$rf+($this->fc*$aDay))):'';

       //fb
       //formulas.fb=eval("(references.rp=='scheduled'&&references.rb=='time'&&references.rn)?formulas.fb1:(references.rp=='scheduled'&&references.rb=='time'&&!references.rn)?formulas.fb2:(references.rp=='scheduled'&&references.rb=='use'&&references.rn)?formulas.fb3:formulas.fb4");
       if(strtolower($this->scheduletype)=="scheduled"&&strtolower($this->rcm->RCM19)=="time"&&$rn){
          $this->fb=$this->fb1;
       }
       else if(strtolower($this->scheduletype)=="scheduled"&&strtolower($this->rcm->RCM19)=="time"&&!$rn){
          $this->fb=$this->fb2;
       }   
       else if(strtolower($this->scheduletype)=="scheduled"&&strtolower($this->rcm->RCM19)=="use"&&$rn){
          $this->fb=$this->fb3;
       }
       else{
          $this->fb=$this->fb4;
       }
       
       //fj
       //formulas.fj=(references.classification=="O")?lifeRemaining(references):'';
       $this->fj=strtoupper($this->rcm->RCM13)=="O"?$this->lifeRemaining():'';

       //fk
       //formulas.fk=(references.classification=="O")?((lifeRemaining(references)*80)/100):'';
       $this->fk=strtoupper($this->rcm->RCM13)=="O"?($this->lifeRemaining()*80)/100:'';

       //fl
       //formulas.fl=(references.classification=="S")?lifeRemaining(references):'';
       $this->fl=strtoupper($this->rcm->RCM13)=="S"?$this->lifeRemaining():'';

       //fm
       //formulas.fm=(references.classification=="S")?((lifeRemaining(references)*50)/100):'';
       $this->fm=strtoupper($this->rcm->RCM13)=="S"?($this->lifeRemaining()*50)/100:'';

       //fe
       //formulas.fe=lifeRemainingUsage(references);
       $this->fe=$this->lifeRemainingUsage();

       //ff
       //formulas.ff=(references.classification=="O")?(references.rm)?(formulas.fe/(references.rl-references.rk))*(((references.rn.getTime()-references.rm.getTime())/aDay)/365):formulas.fe/references.rg:'';
       if(strtoupper($this->rcm->RCM13)=="O"){
           if($rm){
               //echo "ff form=(".$this->fe."/(".$this->odometer."-".$this->previousodometer."))*((".$rn."-".$rm.")/".$aDay."/365)<br>";
               $this->ff=($this->fe/($this->odometer-$this->previousodometer))*(($rn-$rm)/$aDay/365);  
           }
           else{
               $this->ff=$this->fe/1200;
               //previously:$this->ff=$this->fe/$this->rcm->RCM30;
           }
       }
       else{
           $this->ff='';
       }
       
       //fg
       //formulas.fg=(references.classification=="O")?parseFloat((formulas.ff*80)/100):'';
       $this->fg=strtoupper($this->rcm->RCM13)=="O"?(($this->ff*80)/100):'';
     
       //fh
       //formulas.fh=(references.classification=="S")?(references.rm)?(formulas.fe/(references.rl-references.rk))*(((references.rn.getTime()-references.rm.getTime())/aDay)/365):formulas.fe/references.rg:'';
       
       if(strtoupper($this->rcm->RCM13)=="S"){
           if($rm){
               $this->fh=($this->fe/($this->odometer-$this->previousodometer))*(($rn-$rm)/$aDay/365);  
           }
           else{
               $this->fh=$this->fe/$this->rcm->RCM30;
           }
       }
       else{
           $this->fh='';
       }

       //fi
       //formulas.fi=(references.classification=="S")?((formulas.fh*50)/100):'';
       $this->fi=strtoupper($this->rcm->RCM13)=="S"?(($this->fh*50)/100):'';

       //fn
       switch($this->flawsize){

          case "no":
          $this->fn=5;
          break;

          case "yes":
          $this->fn=0;
          break;
       
          default:
          $this->fn=strtoupper($this->rcm->RCM19)=='time'?$this->inspectionInterval($this->fk):$this->inspectionInterval($this->fg);
          //previously: $this->fn=strtolower($this->rcm->RCM19)=='time'?$this->inspectionInterval($this->fk):$this->inspectionInterval($this->fg);
          break;
      }
      //fo
      //formulas.fo=eval("references.rj=='no'?5:references.rj=='yes'?0:references.rb=='time'?inspectionInterval(formulas.fm):inspectionInterval(parseFloat(formulas.fi))");
      
      switch($this->flawsize){
          
          case "no":
          $this->fo=5;
          break;

          case "yes":
          $this->fo=0;

          default:
          $this->fo=strtoupper($this->rcm->RCM19)=='time'?$this->inspectionInterval($this->fm):$this->inspectionInterval($this->fi);
          //previously: $this->fo=strtolower($this->rcm->RCM19)=='time'?$this->inspectionInterval($this->fm):$this->inspectionInterval($this->fi);
      }
      
      //fd
      //formulas.fd=(references.classification=="O")?new Date((formulas.fn*aDay*365)+references.rn.getTime()):new Date((formulas.fo*aDay*365)+references.rn.getTime());
      $this->fd=strtoupper($this->rcm->RCM13)=="O"?strtotime(date('m/d/Y', ($this->fn*$aDay*365)+$rn)):strtotime(date('m/d/Y', ($this->fo*$aDay*365)+$rn));

      //fz
      //formulas.fp=(references.rp=='scheduled')?(formulas.fd>formulas.fb)?formulas.fb:formulas.fd:references.rf;
      if(strtolower($this->scheduletype)=='scheduled'){
         $this->fz=strtotime($this->fd);//(bool)(strtotime($this->fd)<strtotime($this->fb));
       

      }
      else{
         $this->fz = $this->rcm->RCM32;
         //previously: $this-$this->rcm->RCM32;
      }      
      
      //fp
      //formulas.fp=(references.rp=='scheduled')?(formulas.fd>formulas.fb)?formulas.fb:formulas.fd:references.rf;
      if(strtolower($this->scheduletype)=='scheduled'){
         if($this->fd<$this->fb){
             $this->fp=$this->fd;
         }
         else if($this->fb<$this->fd){
             $this->fp=$this->fb;
         }
         else{
             $this->fp=$this->fb;
         }

      }
      else{
         $this->fp=strtotime(date(str_replace("/","-",$this->rcm->RCM32)));
      }
    }


    
 

    public function lifeRemaining(){
       $rm=strtotime($this->previousinspectiondate);
       $rn=strtotime($this->inspectiondate);
       $result=0;

       $aDay=24*60*60;
       //previously: $interval=(strtolower($this->scheduletype)=='scheduled')?$this->rcm->RCM21:12;

                 if($rm){
                     //check if crack related
                     if(strtolower($this->rcm->RCM12)=='crack'){
                         //error check
                         if($this->flawsize>=$this->condemnationcriteria){
                             $result=0;
                         }
                         else if($this->flawsize==$this->previousflawsize||$this->flawsize<$this->previousflawsize)
                         {
                              $result=10000000;
                         }
                         //non-error
                         else{
                             $result=(($this->condemnationcriteria-$this->flawsize)/($this->flawsize-$this->previousflawsize))*((($rn-$rm)/$aDay)/365);
                             //previously: $result=(($this->condemnationcriteria-$this->previousflawsize)/($this->flawsize-$this->previousflawsize))*((($rn-$rm)/$aDay)/365);
                         }
                     }
                     else{
                        //non crack related
                        //error
                        if($this->previousflawsize==$this->flawsize||$this->flawsize>$this->previousflawsize){
                        //previously: if($this->previousflawsize==$this->flawsize||$this->previousflawsize>$this->flawsize){
                            $result=10000000;
                        }
                        else if($this->flawsize<=$this->condemnationcriteria){
                             $result=0;
                        }
                        else{
                            $result=(($this->flawsize-$this->condemnationcriteria)/($this->previousflawsize-$this->flawsize))*((($rn-$rm)/$aDay)/365);
                            //previously: $result=(($this->flawsize-$this->condemnationcriteria)/($this->previousflawsize-$this->flawsize))*((($rn-$rm)/aDay)/365);
                        }
                   }
                }
                else{
                     //if RM is not present
                     //check if crack related
                     if(strtolower($this->rcm->RCM12)=='crack'){
                         //error check - IF AH=Rj OR Rj>AH, then 0,
                         if($this->flawsize>=$this->condemnationcriteria){
                             $result=0;
                         }
                         //error check - 
                         else if($this->flawsize==0){
                              $result=10000000;
                         }
                         //non-error - ((AH-Rj)/(Rj-0))*(Rc*0.0834)
                         else{
                             $result=(($this->condemnationcriteria-$this->flawsize)/($this->flawsize-0))*(12*0.0834);
                             //previously: $result=(($this->condemnationcriteria-$this->flawsize)/($this->flawsize-0))*($this->rcm->RCM21*0.0834);
                         }
                     }
                     else{
                        //non crack related
                        //error check
                            if($this->condemnationcriteria==$this->flawsize||$this->flawsize>$this->condemnationcriteria){
                            //previously: $result=10000000;
                            //additional
                               if($this->flawsize <= $this->condemnationcriteria)
                                  $result = 0;
                               else if($this->flawsize >= $this->rcm->RCM31)
                                  $result = 10000000;
                        }
                        //previously:else if($this->flawsize<=$this->rcm->RCM31){
                             //$result=0;
                        //}
                        //non-error - ((Rj-AH)/(Rh-Rj))*(Rc*0.0834),
                        else{
                            $result=(($this->flawsize-$this->condemnationcriteria)/(20-$this->flawsize))*(12*0.0834);
                            //previously: $result=(($this->flawsize-$this->condemnationcriteria)/($this->rcm->RCM31-$this->flawsize))*($this->rcm->RCM21*0.0834);
                            
                        }
                   }
                
                }




          return $result;

}

public function lifeRemainingUsage(){
       $rm=strtotime($this->previousinspectiondate);
       $rn=strtotime($this->inspectiondate);
       $result=0;
       $interval=(strtolower($this->scheduletype)=='scheduled')?$this->rcm->RCM21:12;
       
      if(strtolower($this->rcm->RCM12)=='crack'&&$this->flawsize==0){
            $result=10000000;
              return $result;
      }

       if((strtolower($this->rcm->RCM12)=='crack'&&$this->flawsize>=$this->condemnationcriteria)||(strtolower($this->rcm->RCM12)=='erosion'&&$this->flawsize<=$this->condemnationcriteria)||(strtolower($this->rcm->RCM12)=='corrosion'&&$this->flawsize<=$this->condemnationcriteria)){
              $result=0;
              return $result;
       }

       //if odometer reading present
       if($this->previousodometer!=""){
           //error check
           if(($this->flawsize==$this->previousflawsize)||(strtolower($this->rcm->RCM12)=='crack'&&($this->flawsize-$this->previousflawsize)<0)||(strtolower($this->rcm->RCM12)=='erosion'&&($this->previousflawsize-$this->flawsize)<0)||(strtolower($this->rcm->RCM12)=='corrosion'&&($this->previousflawsize-$this->flawsize)<0)){
             $result=10000000;
             return $result;
           }
           //no error
           else{
               if(strtolower($this->rcm->RCM12)=="crack"){
                   //echo "show:(".$this->condemnationcriteria."-".$this->flawsize.")/(".$this->flawsize."-".$this->previousflawsize.")*(".$this->odometer."-".$this->previousodometer.")<br>";
                   $result=(($this->condemnationcriteria-$this->flawsize)/($this->flawsize-$this->previousflawsize))*( $this->odometer-$this->previousodometer);
               }
               else{
                   $result=(($this->flawsize-$this->condemnationcriteria)/($this->previousflawsize-$this->flawsize))*($this->odometer-$this->previousodometer);
              }

           }
       }
       //no odometer reading
       else{
     if(strtolower($this->rcm->RCM12)=='crack'){
             //error check

             if($this->flawsize==0){
               $result=10000000;
               return $result;
             }
                //no error
                $result=(($this->condemnationcriteria-$this->flawsize)/($this->flawsize-0))*($this->rcm->RCM30);
           }
           else{
             //error check
             if($this->rcm->RCM31-$this->flawsize==0){
                $result=10000000;
                return $result;
             }
             //no-error
             $result=(($this->flawsize-$this->condemnationcriteria)/($this->rcm->RCM31-$this->flawsize))*($this->rcm->RCM30);
           }
             


         }
          return $result;

}

public function inspectionInterval($lookup){

    //$result=0;
    $result=$lookup;
    /*if($lookup>=0&&$lookup<=0.166)$result=0;
    if($lookup>0.166&&$lookup<=0.24)$result=0.1667;
    if($lookup>0.24&&$lookup<=0.49)$result=0.25;
    if($lookup>0.49&&$lookup<=0.74)$result=0.5;
    if($lookup>0.74&&$lookup<=0.99)$result=0.75;
    if($lookup>0.99&&$lookup<=1.49)$result=1;
    if($lookup>1.49&&$lookup<=1.99)$result=1.5;
    if($lookup>1.99&&$lookup<=2.49)$result=2;
    if($lookup>2.49&&$lookup<=2.99)$result=2.5;
    if($lookup>2.99&&$lookup<=3.49)$result=3;
    if($lookup>3.49&&$lookup<=3.99)$result=3.5;
    if($lookup>3.99&&$lookup<=4.49)$result=4;
    if($lookup>4.49&&$lookup<=4.99)$result=4.5;*/
    if($lookup>4.99)$result=5;

    return $result;

}
    public function tojson(){

             $json= '{"rcm":"'.$this->reference.'",';
             $json.= '"ssiid":"'.$this->ssiid.'",';
             $json.= '"rcmdes":"'.$this->rcm->RCM7A.'",';
             $json.= '"classification":"'.strtoupper($this->rcm->RCM13).'",';
             $json.= '"ra":"'.strtolower($this->rcm->RCM12).'",';
             $json.= '"rb":"'.strtolower($this->rcm->RCM19).'",';
             $json.= '"rc":"'.$this->rcm->RCM21.'",';
             $json.= '"rd":"'.$this->rcm->RCM22.'",';
             $json.= '"re":"'.strtolower($this->rcm->RCM20).'",';
             $json.= '"rf":new Date("'.$this->rcm->RCM32.'"),';
             $json.= '"si":"'.$this->condemnationcriteria.'",';
             $json.= '"rg":"'.$this->rcm->RCM30.'",';
             $json.= '"rh":"'.$this->rcm->RCM31.'",';
             $json.= '"ri":"'.$this->previousflawsize.'",';
             $json.= '"rj":"'.$this->flawsize.'",';
             $json.= '"rk":"'.$this->previousodometer.'",';
             $json.= '"rl":"'.$this->odometer.'",';
             if($this->previousinspectiondate){
                 $json.= '"rm":new Date("'.str_replace('-','/',$this->previousinspectiondate).'"),';
             }
             else{
                 $json.='"rm":"",';
             }
             $json.= '"rn":new Date("'.str_replace('-','/',$this->inspectiondate).'"),';
             $json.= '"rp":"'.$this->scheduletype.'"}';

             return $json;

    }

}

?>